(function( $ ) {
    'use strict';
    var VisualDigitalStreamAnimation = {
        initDigitalStream: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualDigitalStreamAnimation.initDigitalStreamWidget);
        },
        initDigitalStreamWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var digitalStreamAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        digitalStreamAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                digitalStreamAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = digitalStreamAnimationArgs.marvy_enable_digitalStream_animation;
                    settings.bgColor = digitalStreamAnimationArgs.marvy_digitalStream_animation_background_color;
                    settings.colorType = digitalStreamAnimationArgs.marvy_digitalStream_animation_color_type;
                    settings.color = digitalStreamAnimationArgs.marvy_digitalStream_animation_color;
                    settings.alpha = digitalStreamAnimationArgs.marvy_digitalStream_animation_alpha;
                    settings.noiseDist = digitalStreamAnimationArgs.marvy_digitalStream_animation_noise_dist;
                });

            } else {
                settings.switch = $scope.data("marvy_enable_digitalstream_animation");
                settings.bgColor = $scope.data("marvy_digitalstream_animation_background_color");
                settings.colorType = $scope.data("marvy_digitalstream_animation_color_type");
                settings.color = $scope.data("marvy_digitalstream_animation_color");
                settings.alpha = $scope.data("marvy_digitalstream_animation_alpha");
                settings.noiseDist = $scope.data("marvy_digitalstream_animation_noise_dist");
            }

            if (settings.switch) {
                digitalStreamAnimation(target, settings, sectionId);
            }
        }
    };

    function digitalStreamAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-digitalAnimation-section-" + sectionId);
        if (checkElement.length >= 0) {

            class Tool {
              // random number.
              static randomNumber(min, max) {
                return Math.floor(Math.random() * (max - min + 1) + min);
              }
            }

            /*
              When want to use angle.
            */

            class Angle {
              constructor(angle) {
                this.a = angle;
                this.rad = this.a * Math.PI / 180;
              }

              incDec(num) {
                this.a += num;
                this.rad = this.a * Math.PI / 180;
                return this.rad;
              }
            }

            /*
              When want to use controller.
            */

            class Controller {
              constructor(id) {
                this.id = document.getElementById(id);
              }
              getVal() {
                return this.id.value;
              }
            }

            let canvas;
            let canvas_el;
            const simplex = new SimplexNoise();

            class Canvas {
              constructor(bool) {
                // create canvas.
                this.canvas = document.createElement("canvas");
                // if on screen.
                if (bool === true) {
                  this.canvas.style.position = 'absolute';
                  this.canvas.style.top = 0;
                  this.canvas.style.width = '100%';
                  this.canvas.style.height = '100%';
                  this.canvas.classList.add("marvy-digitalAnimation-section-" + sectionId);
                  this.canvas_el = document.querySelector(target).appendChild(this.canvas);
                }
                this.ctx = this.canvas.getContext("2d");
                this.width = this.canvas.width = this.canvas_el.offsetWidth;
                this.height = this.canvas.height = this.canvas_el.offsetHeight;
                // mouse infomation.
                this.mouseX = null;
                this.mouseY = null;
                // controller
                this.checkbox = true;
                // Shape
                this.shapes = [];
                this.width > this.height ? this.size = 20 : this.size = 20;
                this.xNum = this.width / this.size + 1;
                this.yNum = this.height / this.size + 1;
                this.noiseDist = settings.noiseDist;
                this.flg = false;
              }

              // init, render, resize
              init() {
                for (let x = 0; x < this.xNum; x++) {
                  if (this.shapes.length > 2000) break;
                  for (let y = 0; y < this.yNum; y++) {
                    let s = new Shape(this.ctx, x * this.size, y * this.size, this.size);
                    this.shapes.push(s);
                  }
                }
              }

              render() {
                this.ctx.globalCompositeOperation = "darken";
                this.ctx.globalAlpha = settings.alpha;
                this.ctx.fillStyle = settings.bgColor;
                this.ctx.fillRect(0, 0, this.width, this.height);
                this.ctx.globalCompositeOperation = "source-over";
                this.ctx.globalAlpha = 1;
                for (let i = 0; i < this.shapes.length; i++) {
                  this.shapes[i].render();
                }
              }

              resize() {
                this.width = this.canvas.width = this.canvas_el.offsetWidth;
                this.height = this.canvas.height = this.canvas_el.offsetHeight;
                this.shapes = [];
                this.width > this.height ? this.size = 20 : this.size = 20;
                this.xNum = this.width / this.size + 1;
                this.yNum = this.height / this.size + 1;
                this.init();
              }
            }

            /*
              Shape class.
            */

            class Shape {
              constructor(ctx, x, y, r) {
                this.ctx = ctx;
                this.init(x, y, r);
              }

              init(x, y, r) {
                this.x = x;
                this.y = y;
                this.r = r;
                this.t = 1000;
                this.a = new Angle(0);
                if (canvas.width > canvas.height) {
                  this.v = {
                    x: 1,
                    y: 0
                  };
                } else {
                  this.v = {
                    x: 0,
                    y: -1
                  };
                }
                this.l = Tool.randomNumber(10, 100);
              }

              draw() {
                const ctx = this.ctx;
                const color = simplex.noise3D(this.x / 1000, this.y / 1000, this.t) * Math.sin(this.a.rad * 10) * 360;
                ctx.save();
                ctx.globalCompositeOperation = 'lighter';
                if (settings.colorType === 'random') {
                    ctx.fillStyle = 'hsl(' + color + ', 80%, 60%)';
                } else {
                    ctx.fillStyle = settings.color;
                }
                ctx.beginPath();
                ctx.arc(this.x, this.y, this.r / 20, 0, Math.PI * 2, false);
                ctx.fill();
                ctx.restore();
              }

              updatePosition() {
                this.x += (simplex.noise3D(this.x / canvas.noiseDist, this.y / canvas.noiseDist, -this.t) + this.v.x) * 3;
                this.y += (simplex.noise3D(this.x / canvas.noiseDist, this.y / canvas.noiseDist, this.t) + this.v.y) * 3;
              }

              mouseDist() {
                const x = canvas.mouseX - canvas.width / 2;
                const y = canvas.mouseY - canvas.height / 2;
                const d = Math.sqrt(x * x + y * y);
                var colAngle = Math.atan2(canvas.mouseY - canvas.height / 2, canvas.mouseX - canvas.width / 2);
                this.v.x = Math.cos(colAngle);
                this.v.y = Math.sin(colAngle);
                this.x += this.v.x;
                this.y += this.v.y;
              }

              wrapPosition() {
                if (this.x > canvas.width + this.r) {
                  this.relocation();
                }
                if (this.x < 0 - this.r) {
                  this.relocation();
                }
                if (this.y > canvas.height + this.r) {
                  this.relocation();
                }
                if (this.y < 0 - this.r) {
                  this.relocation();
                }
              }

              relocation() {
                this.x = Tool.randomNumber(-50, canvas.width + 50);
                this.y = Tool.randomNumber(-50, canvas.height + 50);
              }

              updateParams() {
                this.t += 0.001;
                this.a.incDec(0.1);
                this.l -= 1;
                if (this.l < 0) {
                  this.l = Tool.randomNumber(10, 100);
                  this.relocation();
                }
              }

              render() {
                this.draw();
                this.updatePosition();
                this.updateParams();
                this.wrapPosition();
                if (canvas.mouseX !== null) this.mouseDist();
              }
            }

            window.addEventListener("load", function () {
              canvas.resize();
            }, false);

            (function () {
              "use strict";

                canvas = new Canvas(true);
                canvas.init();

                function render() {
                  window.requestAnimationFrame(function () {
                    canvas.render();
                    render();
                  });
                }

                render();

                // event
                window.addEventListener("resize", function () {
                  canvas.resize();
                }, false);

                window.addEventListener('mousemove', function(e) {
                  canvas.mouseX = e.clientX;
                  canvas.mouseY = e.clientY;
                }, false);

                canvas.canvas.addEventListener('wheel', function(e) {
                  canvas.noiseDist += e.deltaY / 10;
                }, false);

                // smartphone.
                let touchStartY;
                let touchMoveY;
                let touchEndY;

                canvas.canvas.addEventListener('touchstart', function(e) {
                  const touch = e.targetTouches[0];
                  touchStartY = touch.pageY;
                }, false);

                canvas.canvas.addEventListener('touchmove', function(e) {
                  const touch = e.targetTouches[0];
                  touchMoveY = touch.pageY;
                  touchEndY = touchStartY - touchMoveY;
                  canvas.mouseX = touch.pageX;
                  canvas.mouseY = touch.pageY;
                  if (touchEndY > 0) {
                    canvas.noiseDist += touchEndY / 100;
                  }
                  if (touchEndY < 0) {
                    canvas.noiseDist += touchEndY / 100;
                  }
                }, false);

                canvas.canvas.addEventListener('touchend', function(e) {
                  canvas.mouseX = null;
                  canvas.mouseY = null;
                  touchStartY = null;
                  touchMoveY = null;
                  touchEndY = null;
                }, false);

            })();
        }
        return true;
    }

    $( window ).on('elementor/frontend/init', VisualDigitalStreamAnimation.initDigitalStream);
})( jQuery );